import java.io.*;
import java.util.*;
import org.json.*;

public class Utils
{
	public static void show(){
		showName();
		Scanner input = new Scanner(System.in);

		System.out.print("请输入id: ");
		String text = input.next();
		File file = new File(Main.tencentFile,text);
		if (file.exists()){
			File jtmp = new File(file,text+".jtmp");
			if(jtmp.exists()){
				String json = readJsonFromJtmp(jtmp);
				try {
					JSONArray jsonArry = new JSONArray("["+json+"]");
					JSONObject jsonObject = jsonArry.getJSONObject(0);
					String name = jsonObject.getString("name");
					//String id = jsonObject.getString("id");
					String imgs = jsonObject.getString("imgs");
					File f = new File(Main.putFile,name);
					if(!f.exists()){
						f.mkdirs();
					}
					JSONArray jsonItems = new JSONArray(imgs);
					for(int i = 0;i < jsonItems.length() ; i++){
						JSONObject jo = jsonItems.getJSONObject(i);
						String items_id = jo.getString("id");
						String items_name = jo.getString("name");
						System.out.print("正在提取: "+name + " - "+items_name +"  ");
						boolean b = fileHex.copyGif(new File(file,items_id).getPath(),new File(f,items_name+".gif").getPath());
						System.out.println(b?"成功":"失败");
					}
					System.out.println("完成，储存在"+f.getPath());
				} catch (JSONException e){
					e.getStackTrace();
				}
			}
		} else {
			System.out.println("输入有误");
		}
		System.out.println();
	}
	
	public static void showName(){
		String[] list = Main.tencentFile.list();
		for(int i=0;i<list.length;i++){
			File jtmp = new File(Main.tencentFile,list[i]+"/"+list[i]+".jtmp");
			if(jtmp.exists()){
				String json = readJsonFromJtmp(jtmp);
				try {
					JSONArray jsonArry = new JSONArray("["+json+"]");
					JSONObject jsonObject = jsonArry.getJSONObject(0);
					String name = jsonObject.getString("name");
					String id = jsonObject.getString("id");
					String mark = jsonObject.getString("mark");
					System.out.println("名称："+name+"（id："+id+"）简介："+mark);
				} catch (JSONException e){
					e.getStackTrace();
				}
			}
		}
	}
	
	//读取
    public static String readJsonFromJtmp(File file) {
        if(!file.exists()){
            return null;
        }
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return laststr.toString();
    }
}
